<?php
use Cake\Core\Configure;

$css = ['normalize.min', 'milligram.min', 'cake', 'jBox.all.min'];
if (Configure::read('CustomSetting.mode') === 'speedia') {
    $css[] = 'speedia';
} else if (Configure::read('CustomSetting.mode') === 'accelia') {
    $css[] = 'accelia';
}
$css[] = 'basc';
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>

    <link href="https://fonts.googleapis.com/css?family=Raleway:400,700" rel="stylesheet">

    <?= $this->Html->css($css) ?>
    <?= $this->Html->script(['jquery.min', 'jBox.all.min']) ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>
<body>
    <header>
        <div class="container">
            <?php if (Configure::read('CustomSetting.mode') === 'speedia'): ?>
                <?= $this->Html->image('logo_speedia.png', [
                    'alt' => 'Speedia',
                    'class' => 'header_logo',
                    ]) ?>
            <?php elseif (Configure::read('CustomSetting.mode') === 'accelia'): ?>
                <?= $this->Html->image('logo_accelia.png', [
                    'alt' => 'Accelia',
                    'class' => 'header_logo',
                    ]) ?>
            <?php endif; ?>
        </div>
        <div class="container hp_tar">
            <?php if (Configure::read('CustomSetting.env') === 'beta'): ?>
                <p class="hp_c_ps hp_fs_i">ver.β</p>
            <?php elseif (Configure::read('CustomSetting.env') === 'develop'): ?>
                <p class="hp_c_ps hp_fs_i">ver.α</p>
            <?php endif; ?>
        </div>
    </header>
    <main class="main">
        <div class="container">
            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>
        </div>
    </main>
    <footer>
    </footer>
</body>
</html>
