<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ShortUrl $shortUrl
 */
$this->assign('title', '短縮URL');
?>
<?= $this->Html->css('make_short_url') ?>
<?= $this->Html->script(['prevent_multiple_submit', 'make_short_url']) ?>
<div class="row">
    <div class="column-responsive column-100">
        <div class="bl_logo">
            <?= $this->Html->image('logo_make_short_url.png', ['alt' => 'make_short_url']) ?>
        </div>
        <div class="shortUrl form content">
            <?= $this->Form->create(null) ?>
            <div class="url">
                <?= $this->Form->control('url', [
                    'label' => false,
                    'class' => 'left',
                    'autocomplete' => 'off',
                    ]) ?>
                <?= $this->Form->button(__('短 縮'), ['class' => 'right', 'disabled' => true]) ?>
            </div>
            <div class="custom">
                <div class="custom_hash">
                    <div class="domain"><?= $ShortUrlDomain ?></div>
                    <?= $this->Form->control('custom_hash', [
                        'label' => false,
                        'maxlength' => '20',
                        'placeholder' => 'Hash : 0-9 / a-z / A-Z',
                        'autocomplete' => 'off',
                        ]) ?>
                </div>
            </div>
            <?= $this->Form->end() ?>
            <div class="accordion_btn">
                <div class=triangle></div>
            </div>
            <?php if ($shortUrl ?? false): ?>
                <div class="converted">
                    <p id="converted-url"><?= $shortUrl->converted_url ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
